/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.bridge.request;

import com.ibm.hwmca.fw.bridge.IncomingServiceRequest;
import com.ibm.hwmca.fw.bridge.request.Introspector;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.StringTokenizer;

public abstract class ReqGetField
extends IncomingServiceRequest {
    String objectName;
    String fieldName;

    public void readRequest() throws IOException {
        this.objectName = this.in.readUTF();
        this.fieldName = this.in.readUTF();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeRequest() throws IOException {
        Object target = this.lookupRegisteredObject(this.objectName);
        if (target == null) {
            return;
        }
        Field field = null;
        String fieldNameComponent = "";
        try {
            StringTokenizer tokenizer = new StringTokenizer(this.fieldName, ".");
            if (tokenizer.countTokens() == 0) {
                this.sendError(2, "\"" + this.fieldName + "\" in class " + target.getClass().getName());
                return;
            }
            while (tokenizer.hasMoreTokens()) {
                fieldNameComponent = tokenizer.nextToken();
                field = Introspector.getField(target, fieldNameComponent);
                if (!tokenizer.hasMoreTokens() || (target = field.get(target)) != null) continue;
                this.sendError(26, fieldNameComponent + " in class " + target.getClass().getName());
                return;
            }
            Object object = this.getWriteLock();
            synchronized (object) {
                this.readFieldAndReply(target, field);
                this.out.flush();
            }
        }
        catch (NoSuchFieldException e) {
            this.sendError(2, fieldNameComponent + " in class " + target.getClass().getName());
            return;
        }
        catch (IllegalAccessException e) {
            this.sendError(4, "Field " + fieldNameComponent + " in class " + target.getClass().getName());
        }
    }

    protected abstract void readFieldAndReply(Object var1, Field var2) throws IllegalAccessException, IOException;
}

